/* ///////////////////////////////////////////////////////////////////////// */
/*  This is part of the source of the OMAP 5912 heterogeneous dual-core      */
/*  MPEG-4 SP video decoder published in ACM Transactions on Embedded        */
/*  Computing Systems, Vol. X, Issue Y.                                      */
/* ------------------------------------------------------------------------- */
/*  The source code is released under GPL license.                           */
/*                                                                           */
/*  Copyright, 2011                                                          */
/*  Multimedia Embedded Systems Labs                                         */
/*  Dept. of Computer Science                                                */
/*  National Chiao Tung University                                           */
/*  Hsinchu, Taiwan.                                                         */
/* ------------------------------------------------------------------------- */
/*   bilinear8x8.c                                                           */
/*   MPEG-4 half-pel interpolation functions. This function is a rewrite of  */
/*   the equvalent components of xvidcore 0.9 by Peter Ross                  */
/* ///////////////////////////////////////////////////////////////////////// */

#include "metypes.h"
#include "bilinear8x8.h"

void
halfpel8x8_h(uint16 * dst, uint16 * src, xint stride, xint rounding)
{
    xint    row, col, idx, sum;

    idx = 0;
    for (row = 0; row < (stride << 3); idx = (row += stride))
    {
        for (col = 0; col < 8; col++, idx++)
        {
            sum = (xint) src[idx] + (xint) src[idx + 1] + 1 - rounding;
            dst[idx] = (uint8) (sum >> 1);
        }
    }
}

void
halfpel8x8_v(uint16 * dst, uint16 * src, xint stride, xint rounding)
{
    xint    row, col, idx, sum;

    idx = 0;
    for (row = 0; row < (stride << 3); idx = (row += stride))
    {
        for (col = 0; col < 8; col++, idx++)
        {
            sum = (xint) src[idx] + (xint) src[idx + stride] + 1 - rounding;
            dst[idx] = (uint8) (sum >> 1);
        }
    }
}

void
halfpel8x8_hv(uint16 * dst, uint16 * src, xint stride, xint rounding)
{
    xint    row, col, idx, sum;

    idx = 0;
    for (row = 0; row < (stride << 3); idx = (row += stride))
    {
        for (col = 0; col < 8; col++, idx++)
        {
            sum = (xint) src[idx] + (xint) src[idx + 1] +
                (xint) src[idx + stride] + (xint) src[idx + stride + 1];
            dst[idx] = (uint8) ((sum + 2 - rounding) >> 2);
        }
    }
}
